document.addEventListener("DOMContentLoaded", () => {

    function validateName(name) {
        if (!name.trim()) return "Item name is required.";
        if (name.trim().length < 2) return "Item name must be at least 2 characters.";
        return "";
    }

    function validateQuantity(q) {
        if (!q) return "Quantity is required.";
        if (Number(q) <= 0 || !Number.isInteger(Number(q)))
            return "Quantity must be a positive integer.";
        return "";
    }

    function showError(input, div, msg) {
        div.textContent = msg;
        input.classList.toggle("error", msg !== "");
    }

    // ADD FORM
    const addForm = document.getElementById("add-form");
    if (addForm) {
        const name = document.getElementById("name");
        const qty = document.getElementById("quantity");
        const nameErr = document.getElementById("name-error");
        const qtyErr = document.getElementById("quantity-error");

        addForm.addEventListener("submit", e => {
            const n = validateName(name.value);
            const q = validateQuantity(qty.value);

            showError(name, nameErr, n);
            showError(qty, qtyErr, q);

            if (n || q) e.preventDefault();
        });
    }

    // EDIT FORM
    const editForm = document.getElementById("edit-form");
    if (editForm) {
        const name = document.getElementById("edit-name");
        const qty = document.getElementById("edit-quantity");
        const nameErr = document.getElementById("edit-name-error");
        const qtyErr = document.getElementById("edit-quantity-error");

        editForm.addEventListener("submit", e => {
            const n = validateName(name.value);
            const q = validateQuantity(qty.value);

            showError(name, nameErr, n);
            showError(qty, qtyErr, q);

            if (n || q) e.preventDefault();
        });
    }
});
